// adapted from Original https://www.shadertoy.com/view/Wl3BR7
// Cyclic noise I guess - by michael0884
// Adapted, trivialy, for VGHD by ET.

uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.

#define pi 3.14159265
#define iterations 13

vec3 function(vec3 x){
    vec3 ca = vec3(0.420,0.827,1.000)*cos(x.xxx)+vec3(1.000,0.902,0.859)*cos(x.yyy);
    vec3 cb = vec3(0.898,1.000,0.922)*cos(x.zzz*1.5);
    return ca*cb-cb;
}

mat2 ROT(float ang)
{
    return mat2(cos(ang), sin(ang), -sin(ang), cos(ang));
}

#define SCALE 1.5
#define SHIFT vec3(2.3, -5.2, 1.0)

vec3 fractal(vec3 x){
    x *= pi;
    vec3 v = vec3(0.0);
    float a = 0.5;
    mat2 rmZ = SCALE*ROT(0.35);
    mat2 rmX = SCALE*ROT(0.46);
    for (int i = 0; i < iterations; i++){
        vec3 F =function(x); 
        v += a*F;
        x.xy = rmZ*x.xy;
        x += 0.3*F;
        x.yz = rmX*x.yz;
        x += SHIFT;
        a /= 1.1*SCALE;
    }
    return v;
}
void main( void )
{    
// gl_FragCoord.xy
// u_WindowSize.xy;
// u_Elapsed
// gl_FragColor

///void mainImage( out vec4 fragColor, in vec2 fragCoord ) { ///delete
///void mainImage(out vec4 fragColor, in vec2 fragCoord){ ///
    vec2 uv = 1.5*(gl_FragCoord.xy-0.5*u_WindowSize.xy)/max(u_WindowSize.x, u_WindowSize.y); //changed earlier error gl_FragCoord-0.5 to gl_FragCoord.xy-0.5
    vec3 color = 0.8*fractal(vec3(uv, 0.05*u_Elapsed))+0.4;
    gl_FragColor = vec4(tanh(pow(color, vec3(1.4))), 1.0);
}